

clear


function [y, deriv] = fcn_nr(x)
     y = x^3 + 4*(x)^2 -10; 
    deriv = 3*(x)^2 + 8*x;
    
endfunction

xp = -15:1:15; 
n = length(xp);
for i=1:n
  yp(i) = fcn_nr(xp(i));
end
plot(xp,yp)
xlabel('x')
ylabel('y')
title('Plot of function')



x = input('Enter initial guess of root location: ');

itermax = 10;     // % max # of iterations
iter = 0;
errmax = 0.00001;   //  % convergence tolerance
error1 = 1;


while error1 > errmax & iter < itermax

  iter = iter + 1;
  [f fprime] = fcn_nr(x);
  if fprime == 0
     break;
  end;

  xnew = x - f / fprime;    

  error1 = abs((xnew - x)/xnew) * 100; // % find change from previous

  x = xnew     // % set up for next iteration
disp('Iteration No.')
disp(iter)
disp('the estimated value of the variable x is=')
disp(x) 


end

///----Input Parameters----///

//This code will work for different functions of the variable x. hence the user has to modify the function & its derivative accordingly 
//Itermax==>maximum number of iteration for which the method has to estimate the value of the variable
//errmax==>maximun tolerable error
